%% nanoSMPS
[nsmpsdata, nsmpsinfo] = ARM_CDF_Import('E:\Google Drive\Projects\HI-SCALE SGP\Data\ARM_Data\nanoSMPS_2nd download\sgpaosnanosmpsS01.a1.20160514.000000.nc');

figure; hold on;
multihax = tight_subplot(2,1,[0.01,0.01],[0.1,0.12],[0.08,0.05]);
topplotpos = get(multihax(1),'Position');
botplotpos = get(multihax(2),'Position');

set(multihax(1),'Position',[botplotpos(1), botplotpos(2), botplotpos(3), topplotpos(2)+topplotpos(4)]);
set(multihax(2),'Position',[botplotpos(1), botplotpos(2), botplotpos(3), topplotpos(2)+topplotpos(4)]);

axes(multihax(1));
imagesc(flipud(nsmpsdata.number_size_distribution{1}));
set(gca,'Color','none','XTick',[],'YTick',[]);

timebounds = {[2016, 05, 14, 00, 25, 48], [2016, 05, 14, 23, 37, 40]};
timebounds = cellfun(@datetime,timebounds);
startidx = closest_idx(avgPSAPtime,timebounds(1));
endidx = closest_idx(avgPSAPtime,timebounds(2));

axes(multihax(2));
plot(avgPSAPtime(startidx:endidx),angrbfilt(startidx:endidx),'Color','r');
% plot(conctime(startidx:endidx),conc(startidx:endidx),'Color','m');
smpsylims = get(gca,'YLim');
set(gca,'Color','none','YLim',smpsylims);
hiscale_addrainpatch();

%% SMPS
[smpsdata, smpsinfo] = ARM_CDF_Import('E:\Google Drive\Projects\HI-SCALE SGP\Data\ARM_Data\SMPS_2nd download');

